/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Fracker
extends SolidPump {
    public float itemUseTime = 100.0f;
    public TextureRegion liquidRegion;
    public TextureRegion rotatorRegion;
    public TextureRegion topRegion;

    public Fracker(String name) {
        super(name);
        this.hasItems = true;
        this.ambientSound = Sounds.drill;
        this.ambientSoundVolume = 0.03f;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.productionTime, this.itemUseTime / 60.0f, StatUnit.seconds);
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.rotatorRegion, this.topRegion};
    }

    public class FrackerBuild
    extends SolidPump.SolidPumpBuild {
        public float accumulator;

        public FrackerBuild() {
            super(Fracker.this);
        }

        @Override
        public void drawCracks() {
        }

        @Override
        public void draw() {
            Draw.rect(Fracker.this.region, this.x, this.y);
            super.drawCracks();
            Drawf.liquid(Fracker.this.liquidRegion, this.x, this.y, this.liquids.get(Fracker.this.result) / Fracker.this.liquidCapacity, Fracker.this.result.color);
            Draw.rect(Fracker.this.rotatorRegion, this.x, this.y, this.pumpTime);
            Draw.rect(Fracker.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            if (this.consValid()) {
                if (this.accumulator >= Fracker.this.itemUseTime) {
                    this.consume();
                    this.accumulator -= Fracker.this.itemUseTime;
                }
                super.updateTile();
                this.accumulator += this.delta() * this.efficiency();
            } else {
                this.dumpLiquid(Fracker.this.result);
            }
        }

        @Override
        public float typeLiquid() {
            return this.liquids.get(Fracker.this.result);
        }
    }
}

