/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class GenericCrafter
extends Block {
    @Nullable
    public ItemStack outputItem;
    @Nullable
    public LiquidStack outputLiquid;
    public float craftTime = 80.0f;
    public Effect craftEffect = Fx.none;
    public Effect updateEffect = Fx.none;
    public float updateEffectChance = 0.04f;
    public DrawBlock drawer = new DrawBlock();

    public GenericCrafter(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.ambientSound = Sounds.machine;
        this.sync = true;
        this.ambientSoundVolume = 0.03f;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.factory});
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
        if (this.outputItem != null) {
            this.stats.add(Stat.output, this.outputItem);
        }
        if (this.outputLiquid != null) {
            this.stats.add(Stat.output, this.outputLiquid.liquid, this.outputLiquid.amount * (60.0f / this.craftTime), true);
        }
    }

    @Override
    public void load() {
        super.load();
        this.drawer.load(this);
    }

    @Override
    public void init() {
        this.outputsLiquid = this.outputLiquid != null;
        super.init();
    }

    @Override
    public TextureRegion[] icons() {
        return this.drawer.icons(this);
    }

    @Override
    public boolean outputsItems() {
        return this.outputItem != null;
    }

    public class GenericCrafterBuild
    extends Building {
        public float progress;
        public float totalProgress;
        public float warmup;

        @Override
        public void draw() {
            GenericCrafter.this.drawer.draw(this);
        }

        @Override
        public boolean shouldConsume() {
            if (GenericCrafter.this.outputItem != null && this.items.get(GenericCrafter.this.outputItem.item) >= GenericCrafter.this.itemCapacity) {
                return false;
            }
            return !(GenericCrafter.this.outputLiquid != null && this.liquids.get(GenericCrafter.this.outputLiquid.liquid) >= GenericCrafter.this.liquidCapacity - 0.001f || !this.enabled);
        }

        @Override
        public void updateTile() {
            if (this.consValid()) {
                this.progress += this.getProgressIncrease(GenericCrafter.this.craftTime);
                this.totalProgress += this.delta();
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, 0.02f);
                if (Mathf.chanceDelta(GenericCrafter.this.updateEffectChance)) {
                    GenericCrafter.this.updateEffect.at(this.getX() + Mathf.range((float)GenericCrafter.this.size * 4.0f), this.getY() + (float)Mathf.range(GenericCrafter.this.size * 4));
                }
            } else {
                this.warmup = Mathf.lerp(this.warmup, 0.0f, 0.02f);
            }
            if (this.progress >= 1.0f) {
                this.consume();
                if (GenericCrafter.this.outputItem != null) {
                    for (int i = 0; i < GenericCrafter.this.outputItem.amount; ++i) {
                        this.offload(GenericCrafter.this.outputItem.item);
                    }
                }
                if (GenericCrafter.this.outputLiquid != null) {
                    this.handleLiquid(this, GenericCrafter.this.outputLiquid.liquid, GenericCrafter.this.outputLiquid.amount);
                }
                GenericCrafter.this.craftEffect.at(this.x, this.y);
                this.progress %= 1.0f;
            }
            if (GenericCrafter.this.outputItem != null && this.timer(GenericCrafter.this.timerDump, 5.0f)) {
                this.dump(GenericCrafter.this.outputItem.item);
            }
            if (GenericCrafter.this.outputLiquid != null) {
                this.dumpLiquid(GenericCrafter.this.outputLiquid.liquid);
            }
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return GenericCrafter.this.itemCapacity;
        }

        @Override
        public boolean shouldAmbientSound() {
            return this.cons.valid();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.warmup = read.f();
        }
    }
}

