/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.world.blocks.production.GenericCrafter;

public class GenericSmelter
extends GenericCrafter {
    public Color flameColor = Color.valueOf("ffc999");
    public TextureRegion topRegion;

    public GenericSmelter(String name) {
        super(name);
        this.ambientSound = Sounds.smelter;
        this.ambientSoundVolume = 0.07f;
    }

    public class SmelterBuild
    extends GenericCrafter.GenericCrafterBuild {
        @Override
        public void draw() {
            super.draw();
            if (this.warmup > 0.0f && GenericSmelter.this.flameColor.a > 0.001f) {
                float g = 0.3f;
                float r = 0.06f;
                float cr = Mathf.random(0.1f);
                Draw.alpha((1.0f - g + Mathf.absin(Time.time, 8.0f, g) + Mathf.random(r) - r) * this.warmup);
                Draw.tint(GenericSmelter.this.flameColor);
                Fill.circle(this.x, this.y, 3.0f + Mathf.absin(Time.time, 5.0f, 2.0f) + cr);
                Draw.color(1.0f, 1.0f, 1.0f, this.warmup);
                Draw.rect(GenericSmelter.this.topRegion, this.x, this.y);
                Fill.circle(this.x, this.y, 1.9f + Mathf.absin(Time.time, 5.0f, 1.0f) + cr);
                Draw.color();
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, (60.0f + Mathf.absin(10.0f, 5.0f)) * this.warmup * (float)GenericSmelter.this.size, GenericSmelter.this.flameColor, 0.65f);
        }
    }
}

