/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;

public class LiquidConverter
extends GenericCrafter {
    public LiquidConverter(String name) {
        super(name);
        this.hasLiquids = true;
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void init() {
        if (!this.consumes.has(ConsumeType.liquid) || !(this.consumes.get(ConsumeType.liquid) instanceof ConsumeLiquid)) {
            throw new RuntimeException("LiquidsConverters must have a ConsumeLiquid. Note that filters are not supported.");
        }
        ConsumeLiquid cl = (ConsumeLiquid)this.consumes.get(ConsumeType.liquid);
        cl.update(false);
        this.outputLiquid.amount = cl.amount;
        super.init();
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.output);
        this.stats.add(Stat.output, this.outputLiquid.liquid, this.outputLiquid.amount * 60.0f, true);
    }

    public class LiquidConverterBuild
    extends GenericCrafter.GenericCrafterBuild {
        @Override
        public void drawLight() {
            if (LiquidConverter.this.hasLiquids && LiquidConverter.this.drawLiquidLight && LiquidConverter.this.outputLiquid.liquid.lightColor.a > 0.001f) {
                this.drawLiquidLight(LiquidConverter.this.outputLiquid.liquid, this.liquids.get(LiquidConverter.this.outputLiquid.liquid));
            }
        }

        @Override
        public void updateTile() {
            ConsumeLiquid cl = (ConsumeLiquid)LiquidConverter.this.consumes.get(ConsumeType.liquid);
            if (this.cons.valid()) {
                float use = Math.min(cl.amount * this.edelta(), LiquidConverter.this.liquidCapacity - this.liquids.get(LiquidConverter.this.outputLiquid.liquid));
                this.liquids.remove(cl.liquid, Math.min(use, this.liquids.get(cl.liquid)));
                this.progress += use / cl.amount;
                this.liquids.add(LiquidConverter.this.outputLiquid.liquid, use);
                if (this.progress >= LiquidConverter.this.craftTime) {
                    this.consume();
                    this.progress %= LiquidConverter.this.craftTime;
                }
            }
            this.dumpLiquid(LiquidConverter.this.outputLiquid.liquid);
        }
    }
}

