/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.geom.Geometry;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.Payload;

public class PayloadAcceptor
extends Block {
    public float payloadSpeed = 0.5f;
    public float payloadRotateSpeed = 5.0f;
    public TextureRegion topRegion;
    public TextureRegion outRegion;
    public TextureRegion inRegion;

    public PayloadAcceptor(String name) {
        super(name);
        this.update = true;
        this.sync = true;
    }

    public static boolean blends(Building build, int direction) {
        int size = build.block.size;
        int trns = build.block.size / 2 + 1;
        Building accept = build.nearby(Geometry.d4((int)direction).x * trns, Geometry.d4((int)direction).y * trns);
        return accept != null && accept.block.outputsPayload && (accept.block.size == size && Math.abs(accept.tileX() - build.tileX()) % size == 0 && Math.abs(accept.tileY() - build.tileY()) % size == 0 && (accept.block.rotate && accept.tileX() + Geometry.d4((int)accept.rotation).x * size == build.tileX() && accept.tileY() + Geometry.d4((int)accept.rotation).y * size == build.tileY() || !accept.block.rotate || !accept.block.outputFacing) || accept.block.size < size && (accept.rotation % 2 == 0 ? Math.abs(accept.y - build.y) <= (float)(size * 8 - accept.block.size * 8) / 2.0f : Math.abs(accept.x - build.x) <= (float)(size * 8 - accept.block.size * 8) / 2.0f) && (!accept.block.rotate || accept.front() == build || !accept.block.outputFacing));
    }

    public class PayloadAcceptorBuild<T extends Payload>
    extends Building {
        @Nullable
        public T payload;
        public Vec2 payVector = new Vec2();
        public float payRotation;
        public boolean carried;

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.payload == null;
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            this.payload = payload;
            this.payVector.set(source).sub(this).clamp((float)(-PayloadAcceptor.this.size * 8) / 2.0f, (float)(-PayloadAcceptor.this.size * 8) / 2.0f, (float)(PayloadAcceptor.this.size * 8) / 2.0f, (float)(PayloadAcceptor.this.size * 8) / 2.0f);
            this.payRotation = payload.rotation();
            this.updatePayload();
        }

        @Override
        public Payload getPayload() {
            return this.payload;
        }

        @Override
        public void pickedUp() {
            this.carried = true;
        }

        @Override
        public void drawTeamTop() {
            this.carried = false;
        }

        @Override
        public Payload takePayload() {
            T t = this.payload;
            this.payload = null;
            return t;
        }

        @Override
        public void onRemoved() {
            super.onRemoved();
            if (this.payload != null && !this.carried) {
                this.payload.dump();
            }
        }

        public boolean blends(int direction) {
            return PayloadAcceptor.blends(this, direction);
        }

        public void updatePayload() {
            if (this.payload != null) {
                this.payload.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payRotation);
            }
        }

        public boolean moveInPayload() {
            if (this.payload == null) {
                return false;
            }
            this.updatePayload();
            this.payRotation = Angles.moveToward(this.payRotation, PayloadAcceptor.this.rotate ? this.rotdeg() : 90.0f, PayloadAcceptor.this.payloadRotateSpeed * this.edelta());
            this.payVector.approach(Vec2.ZERO, PayloadAcceptor.this.payloadSpeed * this.delta());
            return this.hasArrived();
        }

        public void moveOutPayload() {
            if (this.payload == null) {
                return;
            }
            this.updatePayload();
            Vec2 dest = Tmp.v1.trns(this.rotdeg(), (float)(PayloadAcceptor.this.size * 8) / 2.0f);
            this.payRotation = Angles.moveToward(this.payRotation, this.rotdeg(), PayloadAcceptor.this.payloadRotateSpeed * this.edelta());
            this.payVector.approach(dest, PayloadAcceptor.this.payloadSpeed * this.delta());
            if (this.payVector.within(dest, 0.001f)) {
                this.payVector.clamp((float)(-PayloadAcceptor.this.size * 8) / 2.0f, (float)(-PayloadAcceptor.this.size * 8) / 2.0f, (float)(PayloadAcceptor.this.size * 8) / 2.0f, (float)(PayloadAcceptor.this.size * 8) / 2.0f);
                Building front = this.front();
                if (front != null && front.block.outputsPayload) {
                    if (this.movePayload((Payload)this.payload)) {
                        this.payload = null;
                    }
                } else if (front == null || !front.tile().solid()) {
                    this.dumpPayload();
                }
            }
        }

        public void dumpPayload() {
            if (this.payload.dump()) {
                this.payload = null;
            }
        }

        public boolean hasArrived() {
            return this.payVector.isZero(0.01f);
        }

        public void drawPayload() {
            if (this.payload != null) {
                this.updatePayload();
                Draw.z(35.0f);
                this.payload.draw();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.payVector.x);
            write.f(this.payVector.y);
            write.f(this.payRotation);
            Payload.write(this.payload, write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.payVector.set(read.f(), read.f());
            this.payRotation = read.f();
            this.payload = Payload.read(read);
        }
    }
}

