/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.ui.Cicon;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Pump
extends LiquidBlock {
    public float pumpAmount = 0.2f;

    public Pump(String name) {
        super(name);
        this.group = BlockGroup.liquids;
        this.floating = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, 60.0f * this.pumpAmount * (float)this.size * (float)this.size, StatUnit.liquidSecond);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        float amount = 0.0f;
        Liquid liquidDrop = null;
        for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
            if (!this.canPump(other)) continue;
            liquidDrop = other.floor().liquidDrop;
            amount += other.floor().liquidMultiplier;
        }
        if (liquidDrop != null) {
            float width = this.drawPlaceText(Core.bundle.formatFloat("bar.pumpspeed", amount * this.pumpAmount * 60.0f, 0), x, y, valid);
            float dx = (float)(x * 8) + this.offset - width / 2.0f - 4.0f;
            float dy = (float)(y * 8) + this.offset + (float)(this.size * 8) / 2.0f + 5.0f;
            Draw.mixcol(Color.darkGray, 1.0f);
            Draw.rect(liquidDrop.icon(Cicon.small), dx, dy - 1.0f);
            Draw.reset();
            Draw.rect(liquidDrop.icon(Cicon.small), dx, dy);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region};
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team) {
        if (this.isMultiblock()) {
            Liquid last = null;
            for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
                if (other.floor().liquidDrop == null) continue;
                if (other.floor().liquidDrop != last && last != null) {
                    return false;
                }
                last = other.floor().liquidDrop;
            }
            return last != null;
        }
        return this.canPump(tile);
    }

    protected boolean canPump(Tile tile) {
        return tile != null && tile.floor().liquidDrop != null;
    }

    public class PumpBuild
    extends LiquidBlock.LiquidBuild {
        public float amount = 0.0f;
        public Liquid liquidDrop = null;

        @Override
        public void draw() {
            Draw.rect(Pump.this.name, this.x, this.y);
            Drawf.liquid(Pump.this.liquidRegion, this.x, this.y, this.liquids.total() / Pump.this.liquidCapacity, this.liquids.current().color);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.amount = 0.0f;
            this.liquidDrop = null;
            for (Tile other : this.tile.getLinkedTiles(tempTiles)) {
                if (!Pump.this.canPump(other)) continue;
                this.liquidDrop = other.floor().liquidDrop;
                this.amount += other.floor().liquidMultiplier;
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.liquidDrop != null && this.liquids.get(this.liquidDrop) < Pump.this.liquidCapacity - 0.01f && this.enabled;
        }

        @Override
        public void updateTile() {
            if (this.consValid() && this.liquidDrop != null) {
                float maxPump = Math.min(Pump.this.liquidCapacity - this.liquids.total(), this.amount * Pump.this.pumpAmount * this.edelta());
                this.liquids.add(this.liquidDrop, maxPump);
            }
            this.dumpLiquid(this.liquids.current());
        }
    }
}

