/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.values.ItemFilterValue;

public class Separator
extends Block {
    public ItemStack[] results;
    public float craftTime;
    public TextureRegion liquidRegion;
    public TextureRegion spinnerRegion;
    public float spinnerSpeed = 3.0f;

    public Separator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.hasLiquids = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, new ItemFilterValue(item -> {
            for (ItemStack i : this.results) {
                if (item != i.item) continue;
                return true;
            }
            return false;
        }));
        this.stats.add(Stat.productionTime, this.craftTime / 60.0f, StatUnit.seconds);
    }

    public class SeparatorBuild
    extends Building {
        public float progress;
        public float totalProgress;
        public float warmup;

        @Override
        public boolean shouldAmbientSound() {
            return this.cons.valid();
        }

        @Override
        public boolean shouldConsume() {
            int total = this.items.total();
            if (Separator.this.consumes.has(ConsumeType.item) && Separator.this.consumes.get(ConsumeType.item) instanceof ConsumeItems) {
                ConsumeItems c = (ConsumeItems)Separator.this.consumes.get(ConsumeType.item);
                for (ItemStack stack : c.items) {
                    total -= this.items.get(stack.item);
                }
            }
            return total < Separator.this.itemCapacity && this.enabled;
        }

        @Override
        public void draw() {
            super.draw();
            Drawf.liquid(Separator.this.liquidRegion, this.x, this.y, this.liquids.total() / Separator.this.liquidCapacity, this.liquids.current().color);
            if (Core.atlas.isFound(Separator.this.spinnerRegion)) {
                Draw.rect(Separator.this.spinnerRegion, this.x, this.y, this.totalProgress * Separator.this.spinnerSpeed);
            }
        }

        @Override
        public void updateTile() {
            this.totalProgress += this.warmup * this.delta();
            if (this.consValid()) {
                this.progress += this.getProgressIncrease(Separator.this.craftTime);
                this.warmup = Mathf.lerpDelta(this.warmup, 1.0f, 0.02f);
            } else {
                this.warmup = Mathf.lerpDelta(this.warmup, 0.0f, 0.02f);
            }
            if (this.progress >= 1.0f) {
                this.progress %= 1.0f;
                int sum = 0;
                for (ItemStack stack : Separator.this.results) {
                    sum += stack.amount;
                }
                int i = Mathf.random(sum);
                int count = 0;
                Item item = null;
                for (ItemStack stack : Separator.this.results) {
                    if (i >= count && i < count + stack.amount) {
                        item = stack.item;
                        break;
                    }
                    count += stack.amount;
                }
                this.consume();
                if (item != null && this.items.get(item) < Separator.this.itemCapacity) {
                    this.offload(item);
                }
            }
            if (this.timer(Separator.this.timerDump, 5.0f)) {
                this.dump();
            }
        }

        @Override
        public boolean canDump(Building to, Item item) {
            return !Separator.this.consumes.itemFilters.get(item.id);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.warmup);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.warmup = read.f();
        }
    }
}

