/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.sandbox;

import arc.graphics.g2d.Draw;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;

public class ItemSource
extends Block {
    public ItemSource(String name) {
        super(name);
        this.hasItems = true;
        this.update = true;
        this.solid = true;
        this.group = BlockGroup.transportation;
        this.configurable = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.config(Item.class, (tile, item) -> {
            tile.outputItem = item;
        });
        this.configClear(tile -> {
            tile.outputItem = null;
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    @Override
    public void drawRequestConfig(BuildPlan req, Eachable<BuildPlan> list) {
        this.drawRequestConfigCenter(req, req.config, "center", true);
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    public class ItemSourceBuild
    extends Building {
        Item outputItem;

        @Override
        public void draw() {
            super.draw();
            if (this.outputItem == null) {
                Draw.rect("cross", this.x, this.y);
            } else {
                Draw.color(this.outputItem.color);
                Draw.rect("center", this.x, this.y);
                Draw.color();
            }
        }

        @Override
        public void updateTile() {
            if (this.outputItem == null) {
                return;
            }
            this.items.set(this.outputItem, 1);
            this.dump(this.outputItem);
            this.items.set(this.outputItem, 0);
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(table, Vars.content.items(), () -> this.outputItem, this::configure);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public Item config() {
            return this.outputItem;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.outputItem == null ? -1 : (int)this.outputItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.outputItem = Vars.content.item(read.s());
        }
    }
}

