/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.sandbox;

import arc.graphics.g2d.Draw;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.meta.BlockGroup;

public class LiquidSource
extends Block {
    public LiquidSource(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.hasLiquids = true;
        this.liquidCapacity = 100.0f;
        this.configurable = true;
        this.outputsLiquid = true;
        this.saveConfig = true;
        this.noUpdateDisabled = true;
        this.displayFlow = false;
        this.group = BlockGroup.liquids;
        this.config(Liquid.class, (tile, l) -> {
            tile.source = l;
        });
        this.configClear(tile -> {
            tile.source = null;
        });
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("liquid");
    }

    @Override
    public void drawRequestConfig(BuildPlan req, Eachable<BuildPlan> list) {
        this.drawRequestConfigCenter(req, req.config, "center", true);
    }

    public class LiquidSourceBuild
    extends Building {
        @Nullable
        public Liquid source = null;

        @Override
        public void updateTile() {
            if (this.source == null) {
                this.liquids.clear();
            } else {
                this.liquids.add(this.source, LiquidSource.this.liquidCapacity);
                this.dumpLiquid(this.source);
            }
        }

        @Override
        public void draw() {
            super.draw();
            if (this.source == null) {
                Draw.rect("cross", this.x, this.y);
            } else {
                Draw.color(this.source.color);
                Draw.rect("center", this.x, this.y);
                Draw.color();
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(table, Vars.content.liquids(), () -> this.source, this::configure);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }

        @Override
        public Liquid config() {
            return this.source;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.source == null ? -1 : (int)this.source.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.source = id == -1 ? null : Vars.content.liquid(id);
        }
    }
}

