/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.EnumSet;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.entities.TargetPriority;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Nulls;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.units.ResupplyPoint;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;
import mindustry.world.modules.ItemModule;

public class CoreBlock
extends StorageBlock {
    private static ItemModule nextItems;
    public UnitType unitType = UnitTypes.alpha;
    public final int timerResupply = this.timers++;
    public int ammoAmount = 5;
    public float resupplyRate = 10.0f;
    public float resupplyRange = 60.0f;
    public Item resupplyItem = Items.copper;

    public CoreBlock(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.priority = TargetPriority.core;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.core, BlockFlag.unitModifier});
        this.unitCapModifier = 10;
        this.loopSound = Sounds.respawning;
        this.loopSoundVolume = 1.0f;
        this.drawDisabled = false;
        this.canOverdrive = false;
        this.replaceable = false;
    }

    public static void playerSpawn(Tile tile, Player player) {
        CoreBuild entity;
        Building building;
        if (player == null || tile == null || !((building = tile.build) instanceof CoreBuild) || (entity = (CoreBuild)building) != (CoreBuild)building) {
            return;
        }
        CoreBlock block = (CoreBlock)tile.block();
        Fx.spawn.at(entity);
        player.set(entity);
        if (!Vars.net.client()) {
            Unit unit = block.unitType.create(tile.team());
            unit.set(entity);
            unit.rotation(90.0f);
            unit.impulse(0.0f, 3.0f);
            unit.controller(player);
            unit.spawnedByCore(true);
            unit.add();
        }
        if (Vars.state.isCampaign() && player == Vars.player) {
            block.unitType.unlock();
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.buildTime);
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("capacity", e -> new Bar(() -> Core.bundle.format("bar.capacity", UI.formatAmount(e.storageCapacity)), () -> Pal.items, () -> (float)e.items.total() / ((float)e.storageCapacity * (float)Vars.content.items().count(i -> i.unlockedNow()))));
    }

    @Override
    public boolean canBreak(Tile tile) {
        return false;
    }

    @Override
    public boolean canReplace(Block other) {
        return super.canReplace(other) || other instanceof CoreBlock && this.size > other.size;
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team) {
        if (tile == null) {
            return false;
        }
        CoreBuild core = team.core();
        if (core == null || !Vars.state.rules.infiniteResources && !core.items.has(this.requirements, Vars.state.rules.buildCostMultiplier)) {
            return false;
        }
        return tile.block() instanceof CoreBlock && this.size > tile.block().size;
    }

    @Override
    public void placeBegan(Tile tile, Block previous) {
        if (previous instanceof CoreBlock) {
            tile.setBlock(this, tile.team());
            Fx.placeBlock.at(tile, (float)tile.block().size);
            Fx.upgradeCore.at(tile, (float)tile.block().size);
            if (nextItems != null) {
                if (tile.team().core() != null) {
                    tile.team().core().items.set(nextItems);
                }
                nextItems = null;
            }
        }
    }

    @Override
    public void beforePlaceBegan(Tile tile, Block previous) {
        if (tile.build instanceof CoreBuild) {
            ItemModule items = tile.build.items.copy();
            if (!Vars.state.rules.infiniteResources) {
                items.remove(ItemStack.mult(this.requirements, Vars.state.rules.buildCostMultiplier));
            }
            nextItems = items;
        }
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        if (Vars.world.tile(x, y) == null) {
            return;
        }
        if (!this.canPlaceOn(Vars.world.tile(x, y), Vars.player.team())) {
            this.drawPlaceText(Core.bundle.get(Vars.player.team().core() != null && Vars.player.team().core().items.has(this.requirements, Vars.state.rules.buildCostMultiplier) || Vars.state.rules.infiniteResources ? "bar.corereq" : "bar.noresources"), x, y, valid);
        }
    }

    public class CoreBuild
    extends Building
    implements ControlBlock {
        public int storageCapacity;
        public BlockUnitc unit = Nulls.blockUnit;
        public boolean noEffect = false;

        @Override
        public double sense(LAccess sensor) {
            if (sensor == LAccess.itemCapacity) {
                return this.storageCapacity;
            }
            return super.sense(sensor);
        }

        @Override
        public void created() {
            this.unit = (BlockUnitc)((Object)UnitTypes.block.create(this.team));
            this.unit.tile(this);
        }

        @Override
        public Unit unit() {
            return (Unit)((Object)this.unit);
        }

        public void requestSpawn(Player player) {
            Call.playerSpawn(this.tile, player);
        }

        @Override
        public void updateTile() {
            if (this.items.has(CoreBlock.this.resupplyItem) && this.timer(CoreBlock.this.timerResupply, CoreBlock.this.resupplyRate) && ResupplyPoint.resupply(this, CoreBlock.this.resupplyRange, CoreBlock.this.ammoAmount, CoreBlock.this.resupplyItem.color)) {
                this.items.remove(CoreBlock.this.resupplyItem, 1);
            }
        }

        @Override
        public boolean canPickup() {
            return false;
        }

        @Override
        public void onDestroyed() {
            super.onDestroyed();
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.waveTeam && this.team.cores().size <= 1) {
                this.tile.setOverlayQuiet(Blocks.spawn);
                if (!Vars.spawner.getSpawns().contains(this.tile)) {
                    Vars.spawner.getSpawns().add(this.tile);
                }
            }
        }

        @Override
        public void drawLight() {
            Drawf.light(this.team, this.x, this.y, 30.0f + 20.0f * (float)CoreBlock.this.size, Pal.accent, 0.65f + Mathf.absin(20.0f, 0.1f));
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Vars.state.rules.coreIncinerates ? this.storageCapacity * 2 : this.storageCapacity;
        }

        @Override
        public void onProximityUpdate() {
            for (Building building : Vars.state.teams.cores(this.team)) {
                if (building.tile() == this.tile) continue;
                this.items = building.items;
            }
            Vars.state.teams.registerCore(this);
            this.storageCapacity = CoreBlock.this.itemCapacity + this.proximity().sum(e -> this.owns((Building)e) ? e.block.itemCapacity : 0);
            this.proximity.each(e -> this.owns((Building)e), t -> {
                t.items = this.items;
                ((StorageBlock.StorageBuild)t).linkedCore = this;
            });
            for (Building building : Vars.state.teams.cores(this.team)) {
                if (building.tile() == this.tile) continue;
                this.storageCapacity += building.block.itemCapacity + building.proximity().sum(e -> this.owns(other, (Building)e) ? e.block.itemCapacity : 0);
            }
            if (!Vars.world.isGenerating()) {
                for (Item item : Vars.content.items()) {
                    this.items.set(item, Math.min(this.items.get(item), this.storageCapacity));
                }
            }
            for (CoreBuild coreBuild : Vars.state.teams.cores(this.team)) {
                coreBuild.storageCapacity = this.storageCapacity;
            }
        }

        @Override
        public void handleStack(Item item, int amount, Teamc source) {
            int realAmount = Math.min(amount, this.storageCapacity - this.items.get(item));
            super.handleStack(item, realAmount, source);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                Vars.state.rules.sector.info.handleCoreItem(item, amount);
                if (realAmount == 0) {
                    Fx.coreBurn.at(this.x, this.y);
                }
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                Vars.state.rules.sector.info.handleCoreItem(item, -result);
            }
            return result;
        }

        @Override
        public void drawSelect() {
            Lines.stroke(1.0f, Pal.accent);
            Cons<Building> outline = b -> {
                for (int i = 0; i < 4; ++i) {
                    Point2 p = Geometry.d8edge[i];
                    float offset = (float)(-Math.max(b.block.size - 1, 0)) / 2.0f * 8.0f;
                    Draw.rect("block-select", b.x + offset * (float)p.x, b.y + offset * (float)p.y, (float)(i * 90));
                }
            };
            this.team.cores().each(core -> {
                outline.get((Building)core);
                core.proximity.each(storage -> storage.items == this.items, outline);
            });
            Draw.reset();
        }

        public boolean owns(Building tile) {
            return this.owns(this, tile);
        }

        public boolean owns(Building core, Building tile) {
            StorageBlock.StorageBuild b;
            Building building = tile;
            return building instanceof StorageBlock.StorageBuild && (b = (StorageBlock.StorageBuild)building) == (StorageBlock.StorageBuild)building && (b.linkedCore == core || b.linkedCore == null);
        }

        @Override
        public float handleDamage(float amount) {
            if (Vars.player != null && this.team == Vars.player.team()) {
                Events.fire(EventType.Trigger.teamCoreDamage);
            }
            return amount;
        }

        @Override
        public void onRemoved() {
            int total = this.proximity.count(e -> e.items != null && e.items == this.items);
            float fract = 1.0f / (float)total / (float)Vars.state.teams.cores((Team)this.team).size;
            this.proximity.each(e -> this.owns((Building)e) && e.items == this.items && this.owns((Building)e), t -> {
                StorageBlock.StorageBuild ent = (StorageBlock.StorageBuild)t;
                ent.linkedCore = null;
                ent.items = new ItemModule();
                for (Item item : Vars.content.items()) {
                    ent.items.set(item, (int)(fract * (float)this.items.get(item)));
                }
            });
            Vars.state.teams.unregisterCore(this);
            int max = CoreBlock.this.itemCapacity * Vars.state.teams.cores((Team)this.team).size;
            for (Item item : Vars.content.items()) {
                this.items.set(item, Math.min(this.items.get(item), max));
            }
            for (CoreBuild other : Vars.state.teams.cores(this.team)) {
                other.onProximityUpdate();
            }
        }

        @Override
        public void placed() {
            super.placed();
            Vars.state.teams.registerCore(this);
        }

        @Override
        public void itemTaken(Item item) {
            if (Vars.state.isCampaign() && this.team == Vars.state.rules.defaultTeam) {
                Vars.state.rules.sector.info.handleCoreItem(item, -1);
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (Vars.net.server() || !Vars.net.active()) {
                if (this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                    Vars.state.rules.sector.info.handleCoreItem(item, 1);
                }
                if (this.items.get(item) >= this.storageCapacity) {
                    if (!this.noEffect) {
                        StorageBlock.incinerateEffect(this, source);
                    }
                    this.noEffect = false;
                } else {
                    super.handleItem(source, item);
                }
            } else if (Vars.state.rules.coreIncinerates && this.items.get(item) >= this.storageCapacity && !this.noEffect) {
                StorageBlock.incinerateEffect(this, source);
                this.noEffect = false;
            }
        }
    }
}

