/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.math.Mathf;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Edges;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;

public class StorageBlock
extends Block {
    public StorageBlock(String name) {
        super(name);
        this.hasItems = true;
        this.solid = true;
        this.update = false;
        this.destructible = true;
        this.group = BlockGroup.transportation;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.storage});
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    public static void incinerateEffect(Building self, Building source) {
        if (Mathf.chance(0.3)) {
            Tile edge = Edges.getFacingEdge(source, self);
            Tile edge2 = Edges.getFacingEdge(self, source);
            if (edge != null && edge2 != null) {
                Fx.coreBurn.at((edge.worldx() + edge2.worldx()) / 2.0f, (edge.worldy() + edge2.worldy()) / 2.0f);
            }
        }
    }

    public class StorageBuild
    extends Building {
        @Nullable
        protected Building linkedCore;

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.linkedCore != null ? this.linkedCore.acceptItem(source, item) : this.items.get(item) < this.getMaximumAccepted(item);
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (this.linkedCore != null) {
                if (this.linkedCore.items.get(item) >= ((CoreBlock.CoreBuild)this.linkedCore).storageCapacity) {
                    StorageBlock.incinerateEffect(this, source);
                }
                ((CoreBlock.CoreBuild)this.linkedCore).noEffect = true;
                this.linkedCore.handleItem(source, item);
            } else {
                super.handleItem(source, item);
            }
        }

        @Override
        public void itemTaken(Item item) {
            if (this.linkedCore != null) {
                this.linkedCore.itemTaken(item);
            }
        }

        @Override
        public int removeStack(Item item, int amount) {
            int result = super.removeStack(item, amount);
            if (this.linkedCore != null && this.team == Vars.state.rules.defaultTeam && Vars.state.isCampaign()) {
                Vars.state.rules.sector.info.handleCoreItem(item, -result);
            }
            return result;
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return StorageBlock.this.itemCapacity;
        }

        @Override
        public void drawSelect() {
            if (this.linkedCore != null) {
                this.linkedCore.drawSelect();
            }
        }

        @Override
        public void overwrote(Seq<Building> previous) {
            if (this.linkedCore == null) {
                for (Building other : previous) {
                    if (other.items == null || other.items == this.items) continue;
                    this.items.add(other.items);
                }
                this.items.each((i, a) -> this.items.set(i, Math.min(a, StorageBlock.this.itemCapacity)));
            }
        }

        @Override
        public boolean canPickup() {
            return this.linkedCore == null;
        }
    }
}

