/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.storage.StorageBlock;

public class Unloader
extends Block {
    public float speed = 1.0f;
    public final int timerUnload = this.timers++;

    public Unloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.health = 70;
        this.hasItems = true;
        this.configurable = true;
        this.saveConfig = true;
        this.itemCapacity = 0;
        this.noUpdateDisabled = true;
        this.unloadable = false;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void drawRequestConfig(BuildPlan req, Eachable<BuildPlan> list) {
        this.drawRequestConfigCenter(req, req.config, "unloader-center");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.remove("items");
    }

    public class UnloaderBuild
    extends Building {
        public Item sortItem = null;
        public Building dumpingTo;
        public int offset = 0;
        public int[] rotations;

        @Override
        public void updateTile() {
            if (this.timer(Unloader.this.timerUnload, Unloader.this.speed / this.timeScale)) {
                if (this.rotations == null || this.rotations.length != this.proximity.size) {
                    this.rotations = new int[this.proximity.size];
                }
                for (int i = 0; i < this.proximity.size; ++i) {
                    Item item;
                    int pos = (this.offset + i) % this.proximity.size;
                    Building other = (Building)this.proximity.get(pos);
                    if (!other.interactable(this.team) || !other.block.unloadable || !other.canUnload() || !other.block.hasItems || (this.sortItem != null || other.items.total() <= 0) && (this.sortItem == null || !other.items.has(this.sortItem))) continue;
                    this.dumpingTo = other;
                    Item item2 = item = this.sortItem == null ? other.items.takeIndex(this.rotations[pos]) : this.sortItem;
                    if (this.put(item)) {
                        other.items.remove(item, 1);
                        if (this.sortItem == null) {
                            this.rotations[pos] = item.id + 1;
                        }
                        other.itemTaken(item);
                        continue;
                    }
                    if (this.sortItem != null) continue;
                    this.rotations[pos] = other.items.nextIndex(this.rotations[pos]);
                }
                if (this.proximity.size > 0) {
                    ++this.offset;
                    this.offset %= this.proximity.size;
                }
            }
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(this.sortItem == null ? Color.clear : this.sortItem.color);
            Draw.rect("unloader-center", this.x, this.y);
            Draw.color();
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(table, Vars.content.items(), () -> this.sortItem, this::configure);
        }

        @Override
        public boolean onConfigureTileTapped(Building other) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }

        @Override
        public boolean canDump(Building to, Item item) {
            return !(to.block instanceof StorageBlock) && to != this.dumpingTo;
        }

        @Override
        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortItem = id == -1 ? null : Vars.content.items().get(id);
        }
    }
}

