/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.geom.Position;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.util.Strings;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.units.UnitCommand;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;

public class CommandCenter
extends Block {
    public TextureRegionDrawable[] commandRegions = new TextureRegionDrawable[UnitCommand.all.length];
    public Color topColor = null;
    public Color bottomColor = Color.valueOf("5e5e5e");
    public Effect effect = Fx.commandSend;

    public CommandCenter(String name) {
        super(name);
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.rally});
        this.destructible = true;
        this.solid = true;
        this.configurable = true;
        this.drawDisabled = false;
        this.config(UnitCommand.class, (build, command) -> {
            build.team.data().command = command;
            this.effect.at((Position)build);
            Events.fire(new EventType.CommandIssueEvent((Building)build, (UnitCommand)((Object)command)));
        });
    }

    @Override
    public void load() {
        super.load();
        if (Vars.ui != null) {
            for (UnitCommand cmd : UnitCommand.all) {
                this.commandRegions[cmd.ordinal()] = Vars.ui.getIcon("command" + Strings.capitalize(cmd.name()), "cancel");
            }
        }
    }

    public class CommandBuild
    extends Building {
        @Override
        public Object config() {
            return this.team.data().command;
        }

        @Override
        public void draw() {
            super.draw();
            float size = 6.0f;
            Draw.color(CommandCenter.this.bottomColor);
            Draw.rect(CommandCenter.this.commandRegions[this.team.data().command.ordinal()].getRegion(), this.tile.drawx(), this.tile.drawy() - 1.0f, size, size);
            Draw.color(CommandCenter.this.topColor == null ? this.team.color : CommandCenter.this.topColor);
            Draw.rect(CommandCenter.this.commandRegions[this.team.data().command.ordinal()].getRegion(), this.tile.drawx(), this.tile.drawy(), size, size);
            Draw.color();
        }

        @Override
        public void buildConfiguration(Table table) {
            ButtonGroup group = new ButtonGroup();
            Table buttons = new Table();
            for (UnitCommand cmd : UnitCommand.all) {
                buttons.button((Drawable)CommandCenter.this.commandRegions[cmd.ordinal()], Styles.clearToggleTransi, () -> {
                    if (this.team.data().command != cmd) {
                        this.configure((Object)cmd);
                    }
                }).size(44.0f).group(group).update(b -> b.setChecked(this.team.data().command == cmd));
            }
            table.add(buttons);
            table.row();
            table.label(() -> this.team.data().command.localized()).style(Styles.outlineLabel).center().growX().get().setAlignment(1);
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.b(this.team.data().command.ordinal());
        }

        @Override
        public void read(Reads read, byte version) {
            super.read(read, version);
            this.team.data().command = UnitCommand.all[read.b()];
        }
    }
}

