/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Scaling;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Reconstructor
extends UnitBlock {
    public float constructTime = 120.0f;
    public Seq<UnitType[]> upgrades = new Seq();
    public int[] capacities = new int[0];

    public Reconstructor(String name) {
        super(name);
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect(this.region, req.drawx(), req.drawy());
        Draw.rect(this.inRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.rect(this.outRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.rect(this.topRegion, req.drawx(), req.drawy());
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("progress", entity -> new Bar("bar.progress", Pal.ammo, entity::fraction));
        this.bars.add("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), Units.getCap(e.team)), () -> Pal.power, () -> e.unit() == null ? 0.0f : (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team)));
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.productionTime, this.constructTime / 60.0f, StatUnit.seconds);
        this.stats.add(Stat.output, table -> {
            table.row();
            for (UnitType[] upgrade : this.upgrades) {
                float size = 24.0f;
                if (!upgrade[0].unlockedNow() || !upgrade[1].unlockedNow()) continue;
                table.image(upgrade[0].icon(Cicon.small)).size(size).padRight(4.0f).padLeft(10.0f).scaling(Scaling.fit).right();
                table.add(upgrade[0].localizedName).left();
                table.add("[lightgray] -> ");
                table.image(upgrade[1].icon(Cicon.small)).size(size).padRight(4.0f).scaling(Scaling.fit);
                table.add(upgrade[1].localizedName).left();
                table.row();
            }
        });
    }

    @Override
    public void init() {
        this.capacities = new int[Vars.content.items().size];
        if (this.consumes.has(ConsumeType.item) && this.consumes.get(ConsumeType.item) instanceof ConsumeItems) {
            for (ItemStack stack : ((ConsumeItems)this.consumes.get((ConsumeType)ConsumeType.item)).items) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        super.init();
    }

    public class ReconstructorBuild
    extends UnitBlock.UnitBuild {
        public ReconstructorBuild() {
            super(Reconstructor.this);
        }

        public float fraction() {
            return this.progress / Reconstructor.this.constructTime;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            UnitPayload pay;
            Payload payload2;
            return this.payload == null && (this.enabled || source == this) && this.relativeTo(source) != this.rotation && (payload2 = payload) instanceof UnitPayload && (pay = (UnitPayload)payload2) == (UnitPayload)payload2 && this.hasUpgrade(pay.unit.type);
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return Reconstructor.this.capacities[item.id];
        }

        @Override
        public void overwrote(Seq<Building> builds) {
            if (builds.first().block == this.block) {
                this.items.add(builds.first().items);
            }
        }

        @Override
        public void draw() {
            Draw.rect(Reconstructor.this.region, this.x, this.y);
            boolean fallback = true;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(Reconstructor.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
                fallback = false;
            }
            if (fallback) {
                Draw.rect(Reconstructor.this.inRegion, this.x, this.y, (float)(this.rotation * 90));
            }
            Draw.rect(Reconstructor.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.constructing() && this.hasArrived()) {
                Draw.draw(35.0f, () -> {
                    Draw.alpha(1.0f - this.progress / Reconstructor.this.constructTime);
                    Draw.rect(((UnitPayload)this.payload).unit.type.icon(Cicon.full), this.x, this.y, ((UnitPayload)this.payload).rotation() - 90.0f);
                    Draw.reset();
                    Drawf.construct((Building)this, this.upgrade(((UnitPayload)this.payload).unit.type), ((UnitPayload)this.payload).rotation() - 90.0f, this.progress / Reconstructor.this.constructTime, this.speedScl, this.time);
                });
            } else {
                Draw.z(35.0f);
                this.drawPayload();
            }
            Draw.z(35.1f);
            Draw.rect(Reconstructor.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            boolean valid = false;
            if (this.payload != null) {
                if (!this.hasUpgrade(((UnitPayload)this.payload).unit.type)) {
                    this.moveOutPayload();
                } else if (this.moveInPayload()) {
                    if (this.consValid()) {
                        valid = true;
                        this.progress += this.edelta() * Vars.state.rules.unitBuildSpeedMultiplier;
                    }
                    if (this.progress >= Reconstructor.this.constructTime) {
                        ((UnitPayload)this.payload).unit = this.upgrade(((UnitPayload)this.payload).unit.type).create(((UnitPayload)this.payload).unit.team());
                        this.progress %= 1.0f;
                        Effect.shake(2.0f, 3.0f, this);
                        Fx.producesmoke.at(this);
                        this.consume();
                        Events.fire(new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, this));
                    }
                }
            }
            this.speedScl = Mathf.lerpDelta(this.speedScl, Mathf.num(valid), 0.05f);
            this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeedMultiplier;
        }

        @Override
        public boolean shouldConsume() {
            return this.constructing();
        }

        public UnitType unit() {
            if (this.payload == null) {
                return null;
            }
            UnitType t = this.upgrade(((UnitPayload)this.payload).unit.type);
            return t != null && t.unlockedNow() ? t : null;
        }

        public boolean constructing() {
            return this.payload != null && this.hasUpgrade(((UnitPayload)this.payload).unit.type);
        }

        public boolean hasUpgrade(UnitType type) {
            UnitType t = this.upgrade(type);
            return t != null && t.unlockedNow();
        }

        public UnitType upgrade(UnitType type) {
            UnitType[] r = Reconstructor.this.upgrades.find(u -> u[0] == type);
            return r == null ? null : r[1];
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 1) {
                this.progress = read.f();
            }
        }
    }
}

