/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class RepairPoint
extends Block {
    static final Rect rect = new Rect();
    public int timerTarget;
    public float repairRadius;
    public float repairSpeed;
    public float powerUse;
    public TextureRegion baseRegion;
    public TextureRegion laser;
    public TextureRegion laserEnd;
    public Color laserColor;

    public RepairPoint(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.repairRadius = 50.0f;
        this.repairSpeed = 0.3f;
        this.laserColor = Color.valueOf("e8ffd7");
        this.update = true;
        this.solid = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.repair});
        this.hasPower = true;
        this.outlineIcon = true;
        this.expanded = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.range, this.repairRadius / 8.0f, StatUnit.blocks);
    }

    @Override
    public void init() {
        this.consumes.powerCond(this.powerUse, entity -> ((RepairPointBuild)entity).target != null);
        super.init();
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.repairRadius, Pal.accent);
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public class RepairPointBuild
    extends Building
    implements Ranged {
        public Unit target;
        public float strength;
        public float rotation = 90.0f;

        @Override
        public void draw() {
            Draw.rect(RepairPoint.this.baseRegion, this.x, this.y);
            Draw.z(50.0f);
            Drawf.shadow(RepairPoint.this.region, this.x - (float)RepairPoint.this.size / 2.0f, this.y - (float)RepairPoint.this.size / 2.0f, this.rotation - 90.0f);
            Draw.rect(RepairPoint.this.region, this.x, this.y, this.rotation - 90.0f);
            if (this.target != null && Angles.angleDist(this.angleTo(this.target), this.rotation) < 30.0f) {
                Draw.z(116.0f);
                float ang = this.angleTo(this.target);
                float len = 5.0f;
                Draw.color(RepairPoint.this.laserColor);
                Drawf.laser(this.team, RepairPoint.this.laser, RepairPoint.this.laserEnd, this.x + Angles.trnsx(ang, len), this.y + Angles.trnsy(ang, len), this.target.x(), this.target.y(), this.strength);
                Draw.color();
            }
        }

        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, RepairPoint.this.repairRadius, Pal.accent);
        }

        @Override
        public void updateTile() {
            boolean targetIsBeingRepaired = false;
            if (this.target != null && (this.target.dead() || this.target.dst(this.tile) - this.target.hitSize / 2.0f > RepairPoint.this.repairRadius || this.target.health() >= this.target.maxHealth())) {
                this.target = null;
            } else if (this.target != null && this.consValid()) {
                this.target.heal(RepairPoint.this.repairSpeed * this.strength * this.edelta());
                this.rotation = Mathf.slerpDelta(this.rotation, this.angleTo(this.target), 0.5f * this.efficiency() * this.timeScale);
                targetIsBeingRepaired = true;
            }
            this.strength = this.target != null && targetIsBeingRepaired ? Mathf.lerpDelta(this.strength, 1.0f, 0.08f * Time.delta) : Mathf.lerpDelta(this.strength, 0.0f, 0.07f * Time.delta);
            if (this.timer(RepairPoint.this.timerTarget, 20.0f)) {
                rect.setSize(RepairPoint.this.repairRadius * 2.0f).setCenter(this.x, this.y);
                this.target = Units.closest(this.team, this.x, this.y, RepairPoint.this.repairRadius, Healthc::damaged);
            }
        }

        @Override
        public boolean shouldConsume() {
            return this.target != null && this.enabled;
        }

        @Override
        public BlockStatus status() {
            return Mathf.equal(this.efficiency(), 0.0f, 0.01f) ? BlockStatus.noInput : this.cons.status();
        }

        @Override
        public float range() {
            return RepairPoint.this.repairRadius;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.rotation);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.rotation = read.f();
            }
        }

        @Override
        public byte version() {
            return 1;
        }
    }
}

