/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.func.Boolf;
import arc.graphics.Color;
import arc.struct.EnumSet;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.AmmoTypes;
import mindustry.world.Block;
import mindustry.world.meta.BlockFlag;

public class ResupplyPoint
extends Block {
    public final int timerResupply;
    public int ammoAmount;
    public float resupplyRate;
    public float range;
    public Color ammoColor;

    public ResupplyPoint(String name) {
        super(name);
        this.timerResupply = this.timers++;
        this.ammoAmount = 10;
        this.resupplyRate = 5.0f;
        this.range = 60.0f;
        this.ammoColor = Items.copper.color;
        this.update = true;
        this.solid = true;
        this.hasItems = true;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.resupply});
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        Drawf.dashCircle((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, this.range, Pal.placing);
    }

    public static boolean resupply(Building tile, float range, float ammoAmount, Color ammoColor) {
        return ResupplyPoint.resupply(tile.team, tile.x, tile.y, range, ammoAmount, ammoColor, u -> true);
    }

    public static boolean resupply(Team team, float x, float y, float range, float ammoAmount, Color ammoColor, Boolf<Unit> valid) {
        if (!Vars.state.rules.unitAmmo) {
            return false;
        }
        Unit unit = Units.closest(team, x, y, range, u -> u.type.ammoType instanceof AmmoTypes.ItemAmmoType && u.ammo <= (float)u.type.ammoCapacity - ammoAmount && valid.get((Unit)u));
        if (unit != null) {
            Fx.itemTransfer.at(x, y, ammoAmount / 2.0f, ammoColor, unit);
            unit.ammo = Math.min(unit.ammo + ammoAmount, (float)unit.type.ammoCapacity);
            return true;
        }
        return false;
    }

    public class ResupplyPointBuild
    extends Building {
        @Override
        public void drawSelect() {
            Drawf.dashCircle(this.x, this.y, ResupplyPoint.this.range, this.team.color);
        }

        @Override
        public void updateTile() {
            if (this.consValid() && this.timer(ResupplyPoint.this.timerResupply, ResupplyPoint.this.resupplyRate / this.timeScale) && ResupplyPoint.resupply(this, ResupplyPoint.this.range, ResupplyPoint.this.ammoAmount, ResupplyPoint.this.ammoColor)) {
                this.consume();
            }
        }
    }
}

