/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.units.UnitBlock;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.meta.Stat;

public class UnitFactory
extends UnitBlock {
    public int[] capacities = new int[0];
    public Seq<UnitPlan> plans = new Seq(4);

    public UnitFactory(String name) {
        super(name);
        this.update = true;
        this.hasPower = true;
        this.hasItems = true;
        this.solid = true;
        this.configurable = true;
        this.outputsPayload = true;
        this.rotate = true;
        this.config(Integer.class, (tile, i) -> {
            tile.currentPlan = i < 0 || i >= this.plans.size ? -1 : i;
            tile.progress = 0.0f;
        });
        this.config(UnitType.class, (tile, val) -> {
            tile.currentPlan = this.plans.indexOf(p -> p.unit == val);
            tile.progress = 0.0f;
        });
        this.consumes.add(new ConsumeItemDynamic(e -> e.currentPlan != -1 ? this.plans.get((int)e.currentPlan).requirements : ItemStack.empty));
    }

    @Override
    public void init() {
        this.capacities = new int[Vars.content.items().size];
        for (UnitPlan plan : this.plans) {
            for (ItemStack stack : plan.requirements) {
                this.capacities[stack.item.id] = Math.max(this.capacities[stack.item.id], stack.amount * 2);
                this.itemCapacity = Math.max(this.itemCapacity, stack.amount * 2);
            }
        }
        super.init();
    }

    @Override
    public void setBars() {
        super.setBars();
        this.bars.add("progress", e -> new Bar("bar.progress", Pal.ammo, e::fraction));
        this.bars.add("units", e -> new Bar(() -> e.unit() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", Fonts.getUnicodeStr(e.unit().name), e.team.data().countType(e.unit()), Units.getCap(e.team)), () -> Pal.power, () -> e.unit() == null ? 0.0f : (float)e.team.data().countType(e.unit()) / (float)Units.getCap(e.team)));
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.output, table -> {
            Seq<UnitPlan> p = this.plans.select(u -> u.unit.unlockedNow());
            table.row();
            for (UnitPlan plan : p) {
                if (!plan.unit.unlockedNow()) continue;
                table.image(plan.unit.icon(Cicon.small)).size(24.0f).padRight(2.0f).right();
                table.add(plan.unit.localizedName).left();
                table.add(Strings.autoFixed(plan.time / 60.0f, 1) + " " + Core.bundle.get("unit.seconds")).color(Color.lightGray).padLeft(12.0f).left();
                table.row();
            }
        });
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    @Override
    public void drawRequestRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect(this.region, req.drawx(), req.drawy());
        Draw.rect(this.outRegion, req.drawx(), req.drawy(), (float)(req.rotation * 90));
        Draw.rect(this.topRegion, req.drawx(), req.drawy());
    }

    public static class UnitPlan {
        public UnitType unit;
        public ItemStack[] requirements;
        public float time;

        public UnitPlan(UnitType unit, float time, ItemStack[] requirements) {
            this.unit = unit;
            this.time = time;
            this.requirements = requirements;
        }

        UnitPlan() {
        }
    }

    public class UnitFactoryBuild
    extends UnitBlock.UnitBuild {
        public int currentPlan = -1;

        public float fraction() {
            return this.currentPlan == -1 ? 0.0f : this.progress / UnitFactory.this.plans.get((int)this.currentPlan).time;
        }

        @Override
        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit;
            }
            return super.senseObject(sensor);
        }

        @Override
        public void buildConfiguration(Table table) {
            Seq<UnitType> units = Seq.with(UnitFactory.this.plans).map(u -> u.unit).filter(u -> u.unlockedNow());
            if (units.any()) {
                ItemSelection.buildTable(table, units, () -> this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit, unit -> this.configure(UnitFactory.this.plans.indexOf(u -> u.unit == unit)));
            } else {
                table.table(Styles.black3, t -> t.add("@none").color(Color.lightGray));
            }
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return false;
        }

        @Override
        public void display(Table table) {
            super.display(table);
            TextureRegionDrawable reg = new TextureRegionDrawable();
            table.row();
            table.table(t -> {
                t.left();
                t.image().update(i -> {
                    i.setDrawable(this.currentPlan == -1 ? Icon.cancel : reg.set(UnitFactory.this.plans.get((int)this.currentPlan).unit.icon(Cicon.medium)));
                    i.setScaling(Scaling.fit);
                    i.setColor(this.currentPlan == -1 ? Color.lightGray : Color.white);
                }).size(32.0f).padBottom(-4.0f).padRight(2.0f);
                t.label(() -> this.currentPlan == -1 ? "@none" : UnitFactory.this.plans.get((int)this.currentPlan).unit.localizedName).wrap().width(230.0f).color(Color.lightGray);
            }).left();
        }

        @Override
        public Object config() {
            return this.currentPlan;
        }

        @Override
        public void draw() {
            Draw.rect(UnitFactory.this.region, this.x, this.y);
            Draw.rect(UnitFactory.this.outRegion, this.x, this.y, this.rotdeg());
            if (this.currentPlan != -1) {
                UnitPlan plan = UnitFactory.this.plans.get(this.currentPlan);
                Draw.draw(35.0f, () -> Drawf.construct((Building)this, plan.unit, this.rotdeg() - 90.0f, this.progress / plan.time, this.speedScl, this.time));
            }
            Draw.z(35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z(35.1f);
            Draw.rect(UnitFactory.this.topRegion, this.x, this.y);
        }

        @Override
        public void updateTile() {
            if (this.currentPlan < 0 || this.currentPlan >= UnitFactory.this.plans.size) {
                this.currentPlan = -1;
            }
            if (this.consValid() && this.currentPlan != -1) {
                this.time += this.edelta() * this.speedScl * Vars.state.rules.unitBuildSpeedMultiplier;
                this.progress += this.edelta() * Vars.state.rules.unitBuildSpeedMultiplier;
                this.speedScl = Mathf.lerpDelta(this.speedScl, 1.0f, 0.05f);
            } else {
                this.speedScl = Mathf.lerpDelta(this.speedScl, 0.0f, 0.05f);
            }
            this.moveOutPayload();
            if (this.currentPlan != -1 && this.payload == null) {
                UnitPlan plan = UnitFactory.this.plans.get(this.currentPlan);
                if (this.progress >= plan.time && this.consValid()) {
                    this.progress %= 1.0f;
                    this.payload = new UnitPayload(plan.unit.create(this.team));
                    this.payVector.setZero();
                    this.consume();
                    Events.fire(new EventType.UnitCreateEvent(((UnitPayload)this.payload).unit, this));
                }
                this.progress = Mathf.clamp(this.progress, 0.0f, plan.time);
            } else {
                this.progress = 0.0f;
            }
        }

        @Override
        public boolean shouldConsume() {
            if (this.currentPlan == -1) {
                return false;
            }
            return this.enabled && this.payload == null;
        }

        @Override
        public int getMaximumAccepted(Item item) {
            return UnitFactory.this.capacities[item.id];
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.currentPlan != -1 && this.items.get(item) < this.getMaximumAccepted(item) && Structs.contains(UnitFactory.this.plans.get((int)this.currentPlan).requirements, stack -> stack.item == item);
        }

        @Nullable
        public UnitType unit() {
            return this.currentPlan == -1 ? null : UnitFactory.this.plans.get((int)this.currentPlan).unit;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.s(this.currentPlan);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.progress = read.f();
            this.currentPlan = read.s();
        }
    }
}

