/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.ItemImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stats;

public class ConsumeItemDynamic
extends Consume {
    public final Func<Building, ItemStack[]> items;

    public <T extends Building> ConsumeItemDynamic(Func<T, ItemStack[]> items) {
        this.items = items;
    }

    @Override
    public void applyItemFilter(Bits filter) {
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.item;
    }

    @Override
    public void build(Building tile, Table table) {
        ItemStack[][] current = new ItemStack[][]{this.items.get(tile)};
        table.table(cont -> {
            table.update(() -> {
                if (current[0] != this.items.get(tile)) {
                    this.rebuild(tile, (Table)cont);
                    current[0] = this.items.get(tile);
                }
            });
            this.rebuild(tile, (Table)cont);
        });
    }

    private void rebuild(Building tile, Table table) {
        table.clear();
        int i = 0;
        for (ItemStack stack : this.items.get(tile)) {
            table.add(new ReqImage((Element)new ItemImage(stack.item.icon(Cicon.medium), stack.amount), () -> tile.items != null && tile.items.has(stack.item, stack.amount))).padRight(8.0f).left();
            if (++i % 4 != 0) continue;
            table.row();
        }
    }

    @Override
    public String getIcon() {
        return "icon-item";
    }

    @Override
    public void update(Building entity) {
    }

    @Override
    public void trigger(Building entity) {
        for (ItemStack stack : this.items.get(entity)) {
            entity.items.remove(stack);
        }
    }

    @Override
    public boolean valid(Building entity) {
        return entity.items != null && entity.items.has(this.items.get(entity));
    }

    @Override
    public void display(Stats stats) {
    }
}

