/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.ui.Cicon;
import mindustry.ui.ItemImage;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import mindustry.world.meta.values.ItemFilterValue;

public class ConsumeItemFilter
extends Consume {
    public final Boolf<Item> filter;

    public ConsumeItemFilter(Boolf<Item> item) {
        this.filter = item;
    }

    @Override
    public void applyItemFilter(Bits arr) {
        Vars.content.items().each(this.filter, item -> arr.set(item.id));
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.item;
    }

    @Override
    public void build(Building tile, Table table) {
        MultiReqImage image = new MultiReqImage();
        Vars.content.items().each(i -> this.filter.get((Item)i) && i.unlockedNow(), item -> image.add(new ReqImage((Element)new ItemImage(item.icon(Cicon.medium), 1), () -> tile.items != null && tile.items.has((Item)item))));
        table.add(image).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-item";
    }

    @Override
    public void update(Building entity) {
    }

    @Override
    public void trigger(Building entity) {
        for (int i = 0; i < Vars.content.items().size; ++i) {
            Item item = Vars.content.item(i);
            if (entity.items == null || !entity.items.has(item) || !this.filter.get(item)) continue;
            entity.items.remove(item, 1);
            break;
        }
    }

    @Override
    public boolean valid(Building entity) {
        for (int i = 0; i < Vars.content.items().size; ++i) {
            Item item = Vars.content.item(i);
            if (entity.items == null || !entity.items.has(item) || !this.filter.get(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, new ItemFilterValue(this.filter));
    }
}

