/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.ItemImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import mindustry.world.meta.values.ItemListValue;

public class ConsumeItems
extends Consume {
    public final ItemStack[] items;

    public ConsumeItems(ItemStack[] items) {
        this.items = items;
    }

    protected ConsumeItems() {
        this(ItemStack.empty);
    }

    @Override
    public void applyItemFilter(Bits filter) {
        for (ItemStack stack : this.items) {
            filter.set(stack.item.id);
        }
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.item;
    }

    @Override
    public void build(Building tile, Table table) {
        table.table(c -> {
            int i = 0;
            for (ItemStack stack : this.items) {
                c.add(new ReqImage((Element)new ItemImage(stack.item.icon(Cicon.medium), stack.amount), () -> tile.items != null && tile.items.has(stack.item, stack.amount))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                table.row();
            }
        }).left();
    }

    @Override
    public String getIcon() {
        return "icon-item";
    }

    @Override
    public void update(Building entity) {
    }

    @Override
    public void trigger(Building entity) {
        for (ItemStack stack : this.items) {
            entity.items.remove(stack);
        }
    }

    @Override
    public boolean valid(Building entity) {
        return entity.items != null && entity.items.has(this.items);
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, new ItemListValue(this.items));
    }
}

