/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.Cicon;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;

public class ConsumeLiquid
extends ConsumeLiquidBase {
    public final Liquid liquid;

    public ConsumeLiquid(Liquid liquid, float amount) {
        super(amount);
        this.liquid = liquid;
    }

    protected ConsumeLiquid() {
        this(null, 0.0f);
    }

    @Override
    public void applyLiquidFilter(Bits filter) {
        filter.set(this.liquid.id);
    }

    @Override
    public void build(Building tile, Table table) {
        table.add(new ReqImage(this.liquid.icon(Cicon.medium), () -> this.valid(tile))).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-liquid-consume";
    }

    @Override
    public void update(Building entity) {
        entity.liquids.remove(this.liquid, Math.min(this.use(entity), entity.liquids.get(this.liquid)));
    }

    @Override
    public boolean valid(Building entity) {
        return entity != null && entity.liquids != null && entity.liquids.get(this.liquid) >= this.amount * entity.delta();
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, this.liquid, this.amount * 60.0f, true);
    }
}

