/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import arc.struct.Bits;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.Cicon;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import mindustry.world.meta.values.LiquidFilterValue;

public class ConsumeLiquidFilter
extends ConsumeLiquidBase {
    public final Boolf<Liquid> filter;

    public ConsumeLiquidFilter(Boolf<Liquid> liquid, float amount) {
        super(amount);
        this.filter = liquid;
    }

    @Override
    public void applyLiquidFilter(Bits arr) {
        Vars.content.liquids().each(this.filter, item -> arr.set(item.id));
    }

    @Override
    public void build(Building build, Table table) {
        Seq<Liquid> list = Vars.content.liquids().select(l -> !l.isHidden() && this.filter.get((Liquid)l));
        MultiReqImage image = new MultiReqImage();
        list.each(liquid -> image.add(new ReqImage(liquid.icon(Cicon.medium), () -> build.liquids != null && build.liquids.current() == liquid && build.liquids.get((Liquid)liquid) >= Math.max(this.use(build), this.amount * build.delta()))));
        table.add(image).size(32.0f);
    }

    @Override
    public String getIcon() {
        return "icon-liquid-consume";
    }

    @Override
    public void update(Building entity) {
        entity.liquids.remove(entity.liquids.current(), this.use(entity));
    }

    @Override
    public boolean valid(Building entity) {
        return entity != null && entity.liquids != null && this.filter.get(entity.liquids.current()) && entity.liquids.currentAmount() >= this.use(entity);
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, new LiquidFilterValue(this.filter, this.amount * 60.0f, true));
    }
}

