/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.Stats;

public class ConsumePower
extends Consume {
    public final float usage;
    public final float capacity;
    public final boolean buffered;

    public ConsumePower(float usage, float capacity, boolean buffered) {
        this.usage = usage;
        this.capacity = capacity;
        this.buffered = buffered;
    }

    protected ConsumePower() {
        this(0.0f, 0.0f, false);
    }

    @Override
    public ConsumeType type() {
        return ConsumeType.power;
    }

    @Override
    public void build(Building tile, Table table) {
    }

    @Override
    public String getIcon() {
        return "icon-power";
    }

    @Override
    public void update(Building entity) {
    }

    @Override
    public boolean valid(Building entity) {
        if (this.buffered) {
            return true;
        }
        return entity.power.status > 0.0f;
    }

    @Override
    public void display(Stats stats) {
        if (this.buffered) {
            stats.add(Stat.powerCapacity, this.capacity, StatUnit.none);
        } else {
            stats.add(Stat.powerUse, this.usage * 60.0f, StatUnit.powerSecond);
        }
    }

    public float requestedPower(Building entity) {
        if (entity.tile().build == null) {
            return 0.0f;
        }
        if (this.buffered) {
            return (1.0f - entity.power.status) * this.capacity;
        }
        try {
            return this.usage * (float)Mathf.num(entity.shouldConsume());
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

