/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.func.Cons;
import arc.struct.Bits;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.world.blocks.power.ConditionalConsumePower;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumePower;
import mindustry.world.consumers.ConsumeType;
import mindustry.world.meta.Stats;

public class Consumers {
    private Consume[] map = new Consume[ConsumeType.values().length];
    private Consume[] results;
    private Consume[] optionalResults;
    public final Bits itemFilters;
    public final Bits liquidfilters;

    public Consumers() {
        this.itemFilters = new Bits(Vars.content.items().size);
        this.liquidfilters = new Bits(Vars.content.liquids().size);
    }

    public boolean any() {
        return this.results != null && this.results.length > 0;
    }

    public void each(Cons<Consume> c) {
        for (Consume cons : this.map) {
            if (cons == null) continue;
            c.get(cons);
        }
    }

    public void init() {
        this.results = Structs.filter(Consume.class, this.map, m -> m != null);
        this.optionalResults = Structs.filter(Consume.class, this.map, m -> m != null && m.isOptional());
        for (Consume cons : this.results) {
            cons.applyItemFilter(this.itemFilters);
            cons.applyLiquidFilter(this.liquidfilters);
        }
    }

    public ConsumePower getPower() {
        return (ConsumePower)this.get(ConsumeType.power);
    }

    public ConsumeItems getItem() {
        return (ConsumeItems)this.get(ConsumeType.item);
    }

    public boolean hasPower() {
        return this.has(ConsumeType.power);
    }

    public ConsumeLiquid liquid(Liquid liquid, float amount) {
        return this.add(new ConsumeLiquid(liquid, amount));
    }

    public ConsumePower power(float powerPerTick) {
        return this.add(new ConsumePower(powerPerTick, 0.0f, false));
    }

    public <T extends Building> ConsumePower powerCond(float usage, Boolf<T> cons) {
        return this.add(new ConditionalConsumePower(usage, cons));
    }

    public ConsumePower powerBuffered(float powerCapacity) {
        return this.add(new ConsumePower(0.0f, powerCapacity, true));
    }

    public ConsumeItems item(Item item) {
        return this.item(item, 1);
    }

    public ConsumeItems item(Item item, int amount) {
        return this.add(new ConsumeItems(new ItemStack[]{new ItemStack(item, amount)}));
    }

    public ConsumeItems items(ItemStack ... items) {
        return this.add(new ConsumeItems(items));
    }

    public <T extends Consume> T add(T consume) {
        this.map[consume.type().ordinal()] = consume;
        return consume;
    }

    public void remove(ConsumeType type) {
        this.map[type.ordinal()] = null;
    }

    public boolean has(ConsumeType type) {
        return this.map[type.ordinal()] != null;
    }

    public <T extends Consume> T get(ConsumeType type) {
        if (this.map[type.ordinal()] == null) {
            throw new IllegalArgumentException("Block does not contain consumer of type '" + (Object)((Object)type) + "'!");
        }
        return (T)this.map[type.ordinal()];
    }

    @Nullable
    public Consume[] all() {
        return this.results;
    }

    public Consume[] optionals() {
        return this.optionalResults;
    }

    public void display(Stats stats) {
        for (Consume c : this.map) {
            if (c == null) continue;
            c.display(stats);
        }
    }
}

