/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawAnimation
extends DrawBlock {
    public int frameCount = 3;
    public float frameSpeed = 5.0f;
    public boolean sine = true;
    public TextureRegion[] frames;
    public TextureRegion liquid;
    public TextureRegion top;

    @Override
    public void draw(GenericCrafter.GenericCrafterBuild entity) {
        Draw.rect(entity.block.region, entity.x, entity.y);
        Draw.rect(this.sine ? this.frames[(int)Mathf.absin(entity.totalProgress, this.frameSpeed, (float)this.frameCount - 0.001f)] : this.frames[(int)(entity.totalProgress / this.frameSpeed % (float)this.frameCount)], entity.x, entity.y);
        Draw.color(Color.clear, entity.liquids.current().color, entity.liquids.total() / entity.block.liquidCapacity);
        Draw.rect(this.liquid, entity.x, entity.y);
        Draw.color();
        Draw.rect(this.top, entity.x, entity.y);
    }

    @Override
    public void load(Block block) {
        this.frames = new TextureRegion[this.frameCount];
        for (int i = 0; i < this.frameCount; ++i) {
            this.frames[i] = Core.atlas.find(block.name + "-frame" + i);
        }
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{block.region, this.top};
    }
}

