/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawMixer
extends DrawBlock {
    public TextureRegion liquid;
    public TextureRegion top;
    public TextureRegion bottom;

    @Override
    public void draw(GenericCrafter.GenericCrafterBuild entity) {
        float rotation = entity.block.rotate ? entity.rotdeg() : 0.0f;
        Draw.rect(this.bottom, entity.x, entity.y, rotation);
        if (entity.liquids.total() > 0.001f) {
            Draw.color(((GenericCrafter)entity.block).outputLiquid.liquid.color);
            Draw.alpha(entity.liquids.get(((GenericCrafter)entity.block).outputLiquid.liquid) / entity.block.liquidCapacity);
            Draw.rect(this.liquid, entity.x, entity.y, rotation);
            Draw.color();
        }
        Draw.rect(this.top, entity.x, entity.y, rotation);
    }

    @Override
    public void load(Block block) {
        this.liquid = Core.atlas.find(block.name + "-liquid");
        this.top = Core.atlas.find(block.name + "-top");
        this.bottom = Core.atlas.find(block.name + "-bottom");
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.bottom, this.top};
    }
}

