/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawBlock;

public class DrawWeave
extends DrawBlock {
    public TextureRegion weave;
    public TextureRegion bottom;

    @Override
    public void draw(GenericCrafter.GenericCrafterBuild entity) {
        Draw.rect(this.bottom, entity.x, entity.y);
        Draw.rect(this.weave, entity.x, entity.y, entity.totalProgress);
        Draw.color(Pal.accent);
        Draw.alpha(entity.warmup);
        Lines.lineAngleCenter(entity.x + Mathf.sin(entity.totalProgress, 6.0f, 2.6666667f * (float)entity.block.size), entity.y, 90.0f, (float)(entity.block.size * 8) / 2.0f);
        Draw.reset();
        Draw.rect(entity.block.region, entity.x, entity.y);
    }

    @Override
    public void load(Block block) {
        this.weave = Core.atlas.find(block.name + "-weave");
        this.bottom = Core.atlas.find(block.name + "-bottom");
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.bottom, block.region, this.weave};
    }
}

