/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.values.BooleanValue;
import mindustry.world.meta.values.FloorEfficiencyValue;
import mindustry.world.meta.values.ItemListValue;
import mindustry.world.meta.values.LiquidValue;
import mindustry.world.meta.values.NumberValue;
import mindustry.world.meta.values.StringValue;

public class Stats {
    public boolean useCategories = false;
    public boolean intialized = false;
    @Nullable
    private OrderedMap<StatCat, OrderedMap<Stat, Seq<StatValue>>> map;
    private boolean dirty;

    public void add(Stat stat, float value, StatUnit unit) {
        this.add(stat, new NumberValue(value, unit));
    }

    public void add(Stat stat, float value) {
        this.add(stat, value, StatUnit.none);
    }

    public void addPercent(Stat stat, float value) {
        this.add(stat, new NumberValue((int)(value * 100.0f), StatUnit.percent));
    }

    public void add(Stat stat, boolean value) {
        this.add(stat, new BooleanValue(value));
    }

    public void add(Stat stat, Item item) {
        this.add(stat, new ItemListValue(new ItemStack(item, 1)));
    }

    public void add(Stat stat, ItemStack item) {
        this.add(stat, new ItemListValue(item));
    }

    public void add(Stat stat, Liquid liquid, float amount, boolean perSecond) {
        this.add(stat, new LiquidValue(liquid, amount, perSecond));
    }

    public void add(Stat stat, Attribute attr) {
        this.add(stat, attr, false, 1.0f, false);
    }

    public void add(Stat stat, Attribute attr, float scale) {
        this.add(stat, attr, false, scale, false);
    }

    public void add(Stat stat, Attribute attr, boolean floating) {
        this.add(stat, attr, floating, 1.0f, false);
    }

    public void add(Stat stat, Attribute attr, boolean floating, float scale, boolean startZero) {
        for (Floor block2 : Vars.content.blocks().select(block -> {
            Floor f;
            Block f$temp = block;
            return f$temp instanceof Floor && (f = (Floor)f$temp) == (Floor)f$temp && f.attributes.get(attr) != 0.0f && (!f.isLiquid || floating);
        }).as().with(s -> s.sort(f -> f.attributes.get(attr)))) {
            this.add(stat, new FloorEfficiencyValue(block2, block2.attributes.get(attr) * scale, startZero));
        }
    }

    public void add(Stat stat, String format, Object ... args) {
        this.add(stat, new StringValue(format, args));
    }

    public void add(Stat stat, StatValue value) {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (!this.map.containsKey(stat.category)) {
            this.map.put(stat.category, new OrderedMap());
        }
        ((Seq)((Object)((OrderedMap)this.map.get(stat.category)).get(stat, Seq::new))).add(value);
        this.dirty = true;
    }

    public void remove(Stat stat) {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (!this.map.containsKey(stat.category) || !((OrderedMap)this.map.get(stat.category)).containsKey(stat)) {
            throw new RuntimeException("No stat entry found: \"" + (Object)((Object)stat) + "\" in block.");
        }
        ((OrderedMap)this.map.get(stat.category)).remove(stat);
        this.dirty = true;
    }

    public OrderedMap<StatCat, OrderedMap<Stat, Seq<StatValue>>> toMap() {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (this.dirty) {
            this.map.orderedKeys().sort();
            for (ObjectMap.Entry entry : this.map.entries()) {
                ((OrderedMap)entry.value).orderedKeys().sort();
            }
            this.dirty = false;
        }
        return this.map;
    }
}

