/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta.values;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.Strings;
import mindustry.content.StatusEffects;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.gen.Tex;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;

public class AmmoListValue<T extends UnlockableContent>
implements StatValue {
    private final ObjectMap<T, BulletType> map;

    public AmmoListValue(ObjectMap<T, BulletType> map) {
        this.map = map;
    }

    @Override
    public void display(Table table) {
        table.row();
        for (UnlockableContent t : this.map.keys()) {
            boolean unit = t instanceof UnitType;
            BulletType type = this.map.get(t);
            if (!unit & !(t instanceof PowerTurret)) {
                table.image(this.icon(t)).size(24.0f).padRight(4.0f).right().top();
                table.add(t.localizedName).padRight(10.0f).left().top();
            }
            table.table(bt -> {
                bt.left().defaults().padRight(3.0f).left();
                if (type.damage > 0.0f && (type.collides || type.splashDamage <= 0.0f)) {
                    if (type.continuousDamage() > 0.0f) {
                        bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.continuousDamage())) + " " + StatUnit.perSecond.localized());
                    } else {
                        bt.add(Core.bundle.format("bullet.damage", Float.valueOf(type.damage)));
                    }
                }
                if (type.buildingDamageMultiplier != 1.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.buildingdamage", (int)(type.buildingDamageMultiplier * 100.0f)));
                }
                if (type.splashDamage > 0.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.splashdamage", (int)type.splashDamage, Strings.fixed(type.splashDamageRadius / 8.0f, 1)));
                }
                if (!(unit || Mathf.equal(type.ammoMultiplier, 1.0f) || type instanceof LiquidBulletType)) {
                    this.sep((Table)bt, Core.bundle.format("bullet.multiplier", (int)type.ammoMultiplier));
                }
                if (!Mathf.equal(type.reloadMultiplier, 1.0f)) {
                    this.sep((Table)bt, Core.bundle.format("bullet.reload", Strings.autoFixed(type.reloadMultiplier, 2)));
                }
                if (type.knockback > 0.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.knockback", Strings.autoFixed(type.knockback, 2)));
                }
                if (type.healPercent > 0.0f) {
                    this.sep((Table)bt, Core.bundle.format("bullet.healpercent", (int)type.healPercent));
                }
                if (type.pierce || type.pierceCap != -1) {
                    this.sep((Table)bt, type.pierceCap == -1 ? "@bullet.infinitepierce" : Core.bundle.format("bullet.pierce", type.pierceCap));
                }
                if (type.incendAmount > 0) {
                    this.sep((Table)bt, "@bullet.incendiary");
                }
                if (type.status != StatusEffects.none) {
                    this.sep((Table)bt, (type.minfo.mod == null ? type.status.emoji() : "") + "[stat]" + type.status.localizedName);
                }
                if (type.homingPower > 0.01f) {
                    this.sep((Table)bt, "@bullet.homing");
                }
                if (type.lightning > 0) {
                    this.sep((Table)bt, Core.bundle.format("bullet.lightning", type.lightning, Float.valueOf(type.lightningDamage < 0.0f ? type.damage : type.lightningDamage)));
                }
                if (type.fragBullet != null) {
                    this.sep((Table)bt, "@bullet.frag");
                }
            }).padTop(unit ? 0.0f : -9.0f).left().get().background(unit ? null : Tex.underline);
            table.row();
        }
    }

    void sep(Table table, String text) {
        table.row();
        table.add(text);
    }

    TextureRegion icon(T t) {
        return ((UnlockableContent)t).icon(Cicon.medium);
    }
}

