/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta.values;

import arc.Core;
import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.gen.Tex;
import mindustry.type.Liquid;
import mindustry.ui.Cicon;
import mindustry.world.meta.StatValue;

public class BoosterListValue
implements StatValue {
    protected float reload;
    protected float maxUsed;
    protected float multiplier;
    protected boolean baseReload;
    protected Boolf<Liquid> filter;

    public BoosterListValue(float reload, float maxUsed, float multiplier, boolean baseReload, Boolf<Liquid> filter) {
        this.reload = reload;
        this.maxUsed = maxUsed;
        this.baseReload = baseReload;
        this.multiplier = multiplier;
        this.filter = filter;
    }

    @Override
    public void display(Table table) {
        table.row();
        table.table(c -> {
            for (Liquid liquid : Vars.content.liquids()) {
                if (!this.filter.get(liquid)) continue;
                c.image(liquid.icon(Cicon.medium)).size(24.0f).padRight(4.0f).right().top();
                c.add(liquid.localizedName).padRight(10.0f).left().top();
                c.table(Tex.underline, bt -> {
                    bt.left().defaults().padRight(3.0f).left();
                    float reloadRate = (this.baseReload ? 1.0f : 0.0f) + this.maxUsed * this.multiplier * liquid.heatCapacity;
                    float standardReload = this.baseReload ? this.reload : this.reload / (this.maxUsed * this.multiplier * 0.4f);
                    float result = standardReload / (this.reload / reloadRate);
                    bt.add(Core.bundle.format("bullet.reload", Strings.autoFixed(result, 2)));
                }).left().padTop(-9.0f);
                c.row();
            }
        }).colspan(table.getColumns());
        table.row();
    }

    void sep(Table table, String text) {
        table.row();
        table.add(text);
    }
}

