/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta.values;

import arc.func.Boolf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.type.Liquid;
import mindustry.ui.LiquidDisplay;
import mindustry.world.meta.StatValue;

public class LiquidFilterValue
implements StatValue {
    private final Boolf<Liquid> filter;
    private final float amount;
    private final boolean perSecond;

    public LiquidFilterValue(Boolf<Liquid> filter, float amount, boolean perSecond) {
        this.filter = filter;
        this.amount = amount;
        this.perSecond = perSecond;
    }

    @Override
    public void display(Table table) {
        Seq<Liquid> list = new Seq<Liquid>();
        for (Liquid item : Vars.content.liquids()) {
            if (item.isHidden() || !this.filter.get(item)) continue;
            list.add(item);
        }
        for (int i = 0; i < list.size; ++i) {
            table.add(new LiquidDisplay((Liquid)list.get(i), this.amount, this.perSecond)).padRight(5.0f);
            if (i == list.size - 1) continue;
            table.add("/");
        }
    }
}

