/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta.values;

import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.gen.Tex;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.ui.Cicon;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.values.AmmoListValue;

public class WeaponListValue
implements StatValue {
    private final Seq<Weapon> weapons;
    private final UnitType unit;

    public WeaponListValue(UnitType unit, Seq<Weapon> weapons) {
        this.weapons = weapons;
        this.unit = unit;
    }

    @Override
    public void display(Table table) {
        table.row();
        for (int i = 0; i < this.weapons.size; ++i) {
            Weapon weapon = this.weapons.get(i);
            if (weapon.flipSprite) continue;
            TextureRegion region = !weapon.name.equals("") && weapon.outlineRegion.found() ? weapon.outlineRegion : this.unit.icon(Cicon.full);
            table.image(region).size(60.0f).scaling(Scaling.bounded).right().top();
            table.table(Tex.underline, w -> {
                w.left().defaults().padRight(3.0f).left();
                if (weapon.inaccuracy > 0.0f) {
                    this.sep((Table)w, "[lightgray]" + Stat.inaccuracy.localized() + ": [white]" + (int)weapon.inaccuracy + " " + StatUnit.degrees.localized());
                }
                this.sep((Table)w, "[lightgray]" + Stat.reload.localized() + ": " + (weapon.mirror ? "2x " : "") + "[white]" + Strings.autoFixed(60.0f / weapon.reload * (float)weapon.shots, 2));
                AmmoListValue bullet = new AmmoListValue(OrderedMap.of(this.unit, weapon.bullet));
                bullet.display((Table)w);
            }).padTop(-9.0f).left();
            table.row();
        }
    }

    void sep(Table table, String text) {
        table.row();
        table.add(text);
    }
}

