/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.modules;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.BlockStatus;
import mindustry.world.modules.BlockModule;

public class ConsumeModule
extends BlockModule {
    private boolean valid;
    private boolean optionalValid;
    private final Building entity;

    public ConsumeModule(Building entity) {
        this.entity = entity;
    }

    public BlockStatus status() {
        if (!this.entity.shouldConsume()) {
            return BlockStatus.noOutput;
        }
        if (!this.valid || !this.entity.productionValid()) {
            return BlockStatus.noInput;
        }
        return BlockStatus.active;
    }

    public void update() {
        if (this.entity.cheating()) {
            this.optionalValid = true;
            this.valid = true;
            return;
        }
        boolean prevValid = this.valid();
        this.valid = true;
        this.optionalValid = true;
        boolean docons = this.entity.shouldConsume() && this.entity.productionValid();
        for (Consume cons : this.entity.block.consumes.all()) {
            if (cons.isOptional()) continue;
            if (docons && cons.isUpdate() && prevValid && cons.valid(this.entity)) {
                cons.update(this.entity);
            }
            this.valid &= cons.valid(this.entity);
        }
        for (Consume cons : this.entity.block.consumes.optionals()) {
            if (docons && cons.isUpdate() && prevValid && cons.valid(this.entity)) {
                cons.update(this.entity);
            }
            this.optionalValid &= cons.valid(this.entity);
        }
    }

    public void trigger() {
        for (Consume cons : this.entity.block.consumes.all()) {
            cons.trigger(this.entity);
        }
    }

    public boolean valid() {
        return this.valid && this.entity.shouldConsume() && this.entity.enabled;
    }

    public boolean optionalValid() {
        return this.valid() && this.optionalValid && this.entity.enabled;
    }

    @Override
    public void write(Writes write) {
        write.bool(this.valid);
    }

    @Override
    public void read(Reads read) {
        this.valid = read.bool();
    }
}

