/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.modules;

import arc.math.WindowedMean;
import arc.struct.Bits;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.world.modules.BlockModule;

public class ItemModule
extends BlockModule {
    public static final ItemModule empty = new ItemModule();
    private static final int windowSize = 6;
    private static WindowedMean[] cacheFlow;
    private static float[] cacheSums;
    private static float[] displayFlow;
    private static final Bits cacheBits;
    private static final Interval flowTimer;
    private static final float pollScl = 20.0f;
    protected int[] items;
    protected int total;
    protected int takeRotation;
    @Nullable
    private WindowedMean[] flow;

    public ItemModule() {
        this.items = new int[Vars.content.items().size];
    }

    public ItemModule copy() {
        ItemModule out = new ItemModule();
        out.set(this);
        return out;
    }

    public void set(ItemModule other) {
        this.total = other.total;
        this.takeRotation = other.takeRotation;
        System.arraycopy(other.items, 0, this.items, 0, this.items.length);
    }

    public void update(boolean showFlow) {
        if (showFlow) {
            if (flowTimer.get(1, 20.0f)) {
                if (this.flow == null) {
                    int i;
                    if (cacheFlow == null || cacheFlow.length != this.items.length) {
                        cacheFlow = new WindowedMean[this.items.length];
                        for (i = 0; i < this.items.length; ++i) {
                            ItemModule.cacheFlow[i] = new WindowedMean(6);
                        }
                        cacheSums = new float[this.items.length];
                        displayFlow = new float[this.items.length];
                    } else {
                        for (i = 0; i < this.items.length; ++i) {
                            cacheFlow[i].reset();
                        }
                        Arrays.fill(cacheSums, 0.0f);
                        cacheBits.clear();
                    }
                    Arrays.fill(displayFlow, -1.0f);
                    this.flow = cacheFlow;
                }
                boolean updateFlow = flowTimer.get(30.0f);
                for (int i = 0; i < this.items.length; ++i) {
                    this.flow[i].add(cacheSums[i]);
                    if (cacheSums[i] > 0.0f) {
                        cacheBits.set(i);
                    }
                    ItemModule.cacheSums[i] = 0.0f;
                    if (!updateFlow) continue;
                    ItemModule.displayFlow[i] = this.flow[i].hasEnoughData() ? this.flow[i].mean() / 20.0f : -1.0f;
                }
            }
        } else {
            this.flow = null;
        }
    }

    public int length() {
        return this.items.length;
    }

    public float getFlowRate(Item item) {
        if (this.flow == null) {
            return -1.0f;
        }
        return displayFlow[item.id] * 60.0f;
    }

    public boolean hasFlowItem(Item item) {
        if (this.flow == null) {
            return false;
        }
        return cacheBits.get(item.id);
    }

    public void each(ItemConsumer cons) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == 0) continue;
            cons.accept(Vars.content.item(i), this.items[i]);
        }
    }

    public float sum(ItemCalculator calc) {
        float sum = 0.0f;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            sum += calc.get(Vars.content.item(i), this.items[i]);
        }
        return sum;
    }

    public boolean has(Item item) {
        return this.get(item) > 0;
    }

    public boolean has(Item item, int amount) {
        return this.get(item) >= amount;
    }

    public boolean has(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, stack.amount)) continue;
            return false;
        }
        return true;
    }

    public boolean has(ItemSeq items) {
        for (Item item : Vars.content.items()) {
            if (this.has(item, items.get(item))) continue;
            return false;
        }
        return true;
    }

    public boolean has(Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, stack.amount)) continue;
            return false;
        }
        return true;
    }

    public boolean has(ItemStack[] stacks, float multiplier) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, Math.round((float)stack.amount * multiplier))) continue;
            return false;
        }
        return true;
    }

    public boolean hasOne(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (this.has(stack.item, 1)) continue;
            return false;
        }
        return true;
    }

    public boolean empty() {
        return this.total == 0;
    }

    public int total() {
        return this.total;
    }

    public boolean any() {
        return this.total > 0;
    }

    @Nullable
    public Item first() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            return Vars.content.item(i);
        }
        return null;
    }

    @Nullable
    public Item take() {
        for (int i = 0; i < this.items.length; ++i) {
            int index = i + this.takeRotation;
            if (index >= this.items.length) {
                index -= this.items.length;
            }
            if (this.items[index] <= 0) continue;
            int n = index;
            this.items[n] = this.items[n] - 1;
            --this.total;
            this.takeRotation = index + 1;
            return Vars.content.item(index);
        }
        return null;
    }

    @Nullable
    public Item takeIndex(int takeRotation) {
        for (int i = 0; i < this.items.length; ++i) {
            int index = i + takeRotation;
            if (index >= this.items.length) {
                index -= this.items.length;
            }
            if (this.items[index] <= 0) continue;
            return Vars.content.item(index);
        }
        return null;
    }

    public int nextIndex(int takeRotation) {
        for (int i = 1; i < this.items.length; ++i) {
            int index = i + takeRotation;
            if (index >= this.items.length) {
                index -= this.items.length;
            }
            if (this.items[index] <= 0) continue;
            return (takeRotation + i) % this.items.length;
        }
        return takeRotation;
    }

    public int get(int id) {
        return this.items[id];
    }

    public int get(Item item) {
        return this.items[item.id];
    }

    public void set(Item item, int amount) {
        this.total += amount - this.items[item.id];
        this.items[item.id] = amount;
    }

    public void add(Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.add(stack.item, stack.amount);
        }
    }

    public void add(ItemSeq stacks) {
        stacks.each(this::add);
    }

    public void add(ItemModule items) {
        for (int i = 0; i < items.items.length; ++i) {
            this.add(i, items.items[i]);
        }
    }

    public void add(Item item, int amount) {
        this.add(item.id, amount);
    }

    private void add(int item, int amount) {
        int n = item;
        this.items[n] = this.items[n] + amount;
        this.total += amount;
        if (this.flow != null) {
            int n2 = item;
            cacheSums[n2] = cacheSums[n2] + (float)amount;
        }
    }

    public void undoFlow(Item item) {
        if (this.flow != null) {
            short s = item.id;
            cacheSums[s] = cacheSums[s] - 1.0f;
        }
    }

    public void remove(Item item, int amount) {
        amount = Math.min(amount, this.items[item.id]);
        short s = item.id;
        this.items[s] = this.items[s] - amount;
        this.total -= amount;
    }

    public void remove(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            this.remove(stack.item, stack.amount);
        }
    }

    public void remove(ItemSeq stacks) {
        stacks.each(this::remove);
    }

    public void remove(Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.remove(stack.item, stack.amount);
        }
    }

    public void remove(ItemStack stack) {
        this.remove(stack.item, stack.amount);
    }

    public void clear() {
        Arrays.fill(this.items, 0);
        this.total = 0;
    }

    @Override
    public void write(Writes write) {
        int amount = 0;
        for (int item : this.items) {
            if (item <= 0) continue;
            ++amount;
        }
        write.s(amount);
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] <= 0) continue;
            write.s(i);
            write.i(this.items[i]);
        }
    }

    @Override
    public void read(Reads read, boolean legacy) {
        Arrays.fill(this.items, 0);
        int count = legacy ? read.ub() : (int)read.s();
        this.total = 0;
        for (int j = 0; j < count; ++j) {
            int itemamount;
            int itemid = legacy ? read.ub() : (int)read.s();
            this.items[Vars.content.item((int)itemid).id] = itemamount = read.i();
            this.total += itemamount;
        }
    }

    static {
        cacheBits = new Bits();
        flowTimer = new Interval(2);
    }

    public static interface ItemConsumer {
        public void accept(Item var1, int var2);
    }

    public static interface ItemCalculator {
        public float get(Item var1, int var2);
    }
}

