/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.modules;

import arc.math.Mathf;
import arc.math.WindowedMean;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.type.Liquid;
import mindustry.world.modules.BlockModule;

public class LiquidModule
extends BlockModule {
    private static final int windowSize = 3;
    private static final int updateInterval = 60;
    private static final Interval flowTimer = new Interval(2);
    private static final float pollScl = 20.0f;
    private float[] liquids;
    private float total;
    private Liquid current;
    private float smoothLiquid;
    private boolean hadFlow;
    @Nullable
    private WindowedMean flow;
    private float lastAdded;
    private float currentFlowRate;

    public LiquidModule() {
        this.liquids = new float[Vars.content.liquids().size];
        this.current = Vars.content.liquid(0);
    }

    public void update(boolean showFlow) {
        this.smoothLiquid = Mathf.lerpDelta(this.smoothLiquid, this.currentAmount(), 0.1f);
        if (showFlow) {
            if (flowTimer.get(1, 20.0f)) {
                if (this.flow == null) {
                    this.flow = new WindowedMean(3);
                }
                if (this.lastAdded > 1.0E-4f) {
                    this.hadFlow = true;
                }
                this.flow.add(this.lastAdded);
                this.lastAdded = 0.0f;
                if (this.currentFlowRate < 0.0f || flowTimer.get(60.0f)) {
                    this.currentFlowRate = this.flow.hasEnoughData() ? this.flow.mean() / 20.0f : -1.0f;
                }
            }
        } else {
            this.currentFlowRate = -1.0f;
            this.flow = null;
            this.hadFlow = false;
        }
    }

    public float getFlowRate() {
        return this.currentFlowRate * 60.0f;
    }

    public boolean hadFlow() {
        return this.hadFlow;
    }

    public float smoothAmount() {
        return this.smoothLiquid;
    }

    public float total() {
        return this.total;
    }

    public Liquid current() {
        return this.current;
    }

    public void reset(Liquid liquid, float amount) {
        Arrays.fill(this.liquids, 0.0f);
        this.liquids[liquid.id] = amount;
        this.total = amount;
        this.current = liquid;
    }

    public float currentAmount() {
        return this.liquids[this.current.id];
    }

    public float get(Liquid liquid) {
        return this.liquids[liquid.id];
    }

    public void clear() {
        this.total = 0.0f;
        Arrays.fill(this.liquids, 0.0f);
    }

    public void add(Liquid liquid, float amount) {
        short s = liquid.id;
        this.liquids[s] = this.liquids[s] + amount;
        this.total += amount;
        this.current = liquid;
        if (this.flow != null) {
            this.lastAdded += Math.max(amount, 0.0f);
        }
    }

    public void remove(Liquid liquid, float amount) {
        this.add(liquid, -amount);
    }

    public void each(LiquidConsumer cons) {
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            cons.accept(Vars.content.liquid(i), this.liquids[i]);
        }
    }

    public float sum(LiquidCalculator calc) {
        float sum = 0.0f;
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            sum += calc.get(Vars.content.liquid(i), this.liquids[i]);
        }
        return sum;
    }

    @Override
    public void write(Writes write) {
        int amount = 0;
        for (float liquid : this.liquids) {
            if (!(liquid > 0.0f)) continue;
            ++amount;
        }
        write.s(amount);
        for (int i = 0; i < this.liquids.length; ++i) {
            if (!(this.liquids[i] > 0.0f)) continue;
            write.s(i);
            write.f(this.liquids[i]);
        }
    }

    @Override
    public void read(Reads read, boolean legacy) {
        Arrays.fill(this.liquids, 0.0f);
        this.total = 0.0f;
        int count = legacy ? read.ub() : (int)read.s();
        for (int j = 0; j < count; ++j) {
            float amount;
            int liquidid = legacy ? read.ub() : (int)read.s();
            this.liquids[liquidid] = amount = read.f();
            if (amount > 0.0f) {
                this.current = Vars.content.liquid(liquidid);
            }
            this.total += amount;
        }
    }

    public static interface LiquidConsumer {
        public void accept(Liquid var1, float var2);
    }

    public static interface LiquidCalculator {
        public float get(Liquid var1, float var2);
    }
}

